#include "decoderwav.h"

void decoderwav::decode( ){
    int index;
    SDL_AudioSpec wave;
    Uint8 *dataa;
    Uint32 dlen;
    SDL_AudioCVT cvt;

    /* Load the sound file and convert it to 16-bit stereo at 22kHz */
    int s;
    data->get(0, &s);
    SDL_RWops* RW = SDL_RWFromMem(data->get(s,0), s);

    if ( SDL_LoadWAV_RW(RW, false, &wave, &dataa, &dlen) == NULL ) {
        return;
    }
    SDL_BuildAudioCVT(&cvt, wave.format, wave.channels, wave.freq,
                            AUDIO_S16,   2,             44100);
    cvt.buf = (Uint8*)malloc(dlen*cvt.len_mult);
    memcpy(cvt.buf, dataa, dlen);
    cvt.len = dlen;
    SDL_ConvertAudio(&cvt);
    SDL_FreeWAV(dataa);

    samps.push( cvt.buf, dlen*cvt.len_mult );
    free( cvt.buf );
    delete data;
    data = new indata();
}

decoderwav::decoderwav( decoder::info a ){
    __init__( a );
}

decoderwav::~decoderwav( ){
    __destroy__();
}

