#pragma once
#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_OUTLINE_H
//#include <freetype/freetype.h>
#include<vector>
#include<stdarg.h>
#include<cmath>
#include<GL/GL.h>
#define REAL double
//#include "triangle.h"


extern FT_Library library;
void init();

struct bezier{
    struct point{ double x, y; };
    std::vector<point> points;
    bezier();
    bezier(std::vector<point> p);
    bezier(point* p, int len);
    bezier(bool usingpoints, int len, ...);
    void push( double x, double y );
    void push( point p );
    point get( double t );
};


struct font{
    struct vertex{ double x, y; int r, g, b; };
    struct stroke{ std::vector<vertex> points; };
    struct triangle{ vertex points[3]; };
    struct polygon{ std::vector<triangle> triangles; };

    struct glyph{
        int sym;
        std::vector<stroke*> strokes;
        std::vector<polygon> polys;

        struct{ double left,right,top,bottom; } bbox;
        double rightbearing;
        double botbearing;
        double width, height;
        stroke* tmp;
        double penx, peny;
        glyph();
        void finalize();
        void moveto( double x, double y );
        void lineto( double x, double y );
        void conicto( double cx, double cy, double x, double y );
        void cubicto( double c1x, double c1y, double c2x, double c2y, double x, double y );
    };
    std::vector<glyph*> charset;
    double resolution;
    FT_Face face;
    static int process_glyph_moveto( const FT_Vector*  to, void* user );
    static int process_glyph_lineto( const FT_Vector*  to, void* user );
    static int process_glyph_conicto( const FT_Vector*  control, const FT_Vector*  to, void* user );
    static int process_glyph_cubicto( const FT_Vector*  control1, const FT_Vector*  control2, const FT_Vector*  to, void* user );
    glyph* process_glyph(int index);
    font();
    void load( const char* fname);
    font( const char* fname );
    font( const FT_Byte* v, int len );
    ~font();
    void process_set( int mi, int ma );
    glyph* request_glyph( int sym );
    glyph* render_glyph( int sym );
    void render_string( const char* str, double* w = 0 );
    double string_width( const char* str );
};

