#include "geometry.h"
#include <math.h>

void draw::box( double x, double y, double z, bool outline ){
    x/=2;
    y/=2;
    z/=2;
    if( !outline ){
        glBegin( GL_QUADS );
            glNormal3d( -1, 0, 0 );
            glTexCoord2d( 0,0 );
            glVertex3d(-x,-y,-z);
            glTexCoord2d( 1,0 );
            glVertex3d(-x, y,-z);
            glTexCoord2d( 1,1 );
            glVertex3d(-x, y, z);
            glTexCoord2d( 0,1 );
            glVertex3d(-x,-y, z);

            glNormal3d( 0, 0, 1 );
            glTexCoord2d( 0,0 );
            glVertex3d(-x,-y, z);
            glTexCoord2d( 1,0 );
            glVertex3d(-x, y, z);
            glTexCoord2d( 1,1 );
            glVertex3d( x, y, z);
            glTexCoord2d( 0,1 );
            glVertex3d( x,-y, z);

            glNormal3d( 1, 0, 0 );
            glTexCoord2d( 0,0 );
            glVertex3d( x,-y, z);
            glTexCoord2d( 1,0 );
            glVertex3d( x, y, z);
            glTexCoord2d( 1,1 );
            glVertex3d( x, y,-z);
            glTexCoord2d( 0,1 );
            glVertex3d( x,-y,-z);

            glNormal3d( 0, 0, -1 );
            glTexCoord2d( 0,0 );
            glVertex3d( x,-y,-z);
            glTexCoord2d( 1,0 );
            glVertex3d( x, y,-z);
            glTexCoord2d( 1,1 );
            glVertex3d(-x, y,-z);
            glTexCoord2d( 0,1 );
            glVertex3d(-x,-y,-z);
        glEnd();
        glBegin( GL_QUADS );
            glNormal3d( 0, -1, 0 );
            glTexCoord2d( 0,0 );
            glVertex3d(-x,-y,-z);
            glTexCoord2d( 1,0 );
            glVertex3d(-x,-y, z);
            glTexCoord2d( 1,1 );
            glVertex3d( x,-y, z);
            glTexCoord2d( 0,1 );
            glVertex3d( x,-y,-z);

            glNormal3d( 0, 1, 0 );
            glTexCoord2d( 0,0 );
            glVertex3d(-x, y,-z);
            glTexCoord2d( 1,0 );
            glVertex3d(-x, y, z);
            glTexCoord2d( 1,1 );
            glVertex3d( x, y, z);
            glTexCoord2d( 0,1 );
            glVertex3d( x, y,-z);

        glEnd();
    }
    else{
        x += .02;
        y += .02;
        z += .02;
        glBegin( GL_LINES );
            glVertex3d(-x,-y,-z);
            glVertex3d(-x, y,-z);
            glVertex3d(-x,-y, z);
            glVertex3d(-x, y, z);
            glVertex3d( x,-y, z);
            glVertex3d( x, y, z);
            glVertex3d( x,-y,-z);
            glVertex3d( x, y,-z);
            glVertex3d(-x,-y,-z);
            glVertex3d(-x, y,-z);
        glEnd();
        glBegin( GL_LINE_LOOP );
            glVertex3d(-x, y,-z);
            glVertex3d(-x, y, z);
            glVertex3d( x, y, z);
            glVertex3d( x, y,-z);
            glVertex3d(-x, y,-z);
        glEnd();
        glBegin( GL_LINE_LOOP );
            glVertex3d(-x,-y,-z);
            glVertex3d(-x,-y, z);
            glVertex3d( x,-y, z);
            glVertex3d( x,-y,-z);
            glVertex3d(-x,-y,-z);
        glEnd();
    }
}
void draw::pyramid( double x, double y, double z, bool outline, int r, int g, int b, int r2, int g2, int b2  ){
    x/=2;
    y/=2;
    z/=2;
    if( !outline ){
        glBegin( GL_TRIANGLE_FAN );
            double h = sqrt( (2*z)*(2*z) + y * y );

            glNormal3d( 0, y/h, 2*z/h );
            glColor3ub( r, g, b );
            glVertex3d(0, 0, z);
            glColor3ub( r2, g2, b2 );
            glVertex3d(x, y, -z);
            glVertex3d(-x, y, -z);

            h = sqrt( (2*z)*(2*z) + x * x );

            glNormal3d( -x/h, 0, 2*z/h );
            glColor3ub( r, g, b );
            glVertex3d(0, 0, z);
            glColor3ub( r2, g2, b2 );
            glVertex3d(-x, y, -z);
            glVertex3d(-x, -y, -z);

            h = sqrt( (2*z)*(2*z) + y * y );

            glNormal3d( 0, -y/h, 2*z/h );
            glColor3ub( r, g, b );
            glVertex3d(0, 0, z);
            glColor3ub( r2, g2, b2 );
            glVertex3d(-x, -y, -z);
            glVertex3d(x, -y, -z);

            h = sqrt( (2*z)*(2*z) + x * x );

            glNormal3d( x/h, 0, 2*z/h );
            glColor3ub( r, g, b );
            glVertex3d(0, 0, z);
            glColor3ub( r2, g2, b2 );
            glVertex3d(x, -y, -z);
            glVertex3d(x, y, -z);
        glEnd();
        glBegin( GL_QUADS );
            glNormal3d( 0, 0, -1 );
            glVertex3d(x, y, -z);
            glVertex3d(-x, y, -z);
            glVertex3d(-x, -y, -z);
            glVertex3d(x, -y, -z);
        glEnd();

    }
    else{
        x += .02;
        y += .02;
        z += .02;
        glBegin( GL_LINE_LOOP );
            glVertex3d(0, 0, z);
            glVertex3d(-x, -y, -z);
            glVertex3d(x, -y, -z);
            glVertex3d(0, 0, z);
            glVertex3d(-x, y, -z);
            glVertex3d(x, y, -z);
        glEnd();
        glBegin( GL_LINES );
            glVertex3d(-x, -y, -z);
            glVertex3d(-x, y, -z);
            glVertex3d(x, -y, -z);
            glVertex3d(x, y, -z);
        glEnd();
    }
}
