#include "mesh.h"


bool mesh::load_from_bzw( const char* fname ){
    FILE *f = fopen( fname, "r" );
    if( f <= 0 ) return 1;

    const int NUL = 0;
    const int MATERIAL = 1;
    const int MESH = 2;
    const int MESHFACE = 3;

    int state = NUL;
    char buf[1000];
    fgets( buf, 999, f );

    while( !feof( f ) ){
        char* buff = buf;
        while( isspace( *buff ) ) buff++;
        for( int i = 0; buff[i] != 0; i ++ ) if( buff[i] == '\r' || buff[i] == '\n' ) buff[i] = 0;
        char*tu[] = {"NUL", "MATERIAL", "MESH", "MESHFACE"};
        //printf( "%s\n", tu[state] );
        if( !( buff[0] == 0 || buff[0] == '#' ) )
            switch( state ){
                case NUL:
                    if( strcmp( buff, "material" ) == 0 )
                        state = MATERIAL;
                    else if( strcmp( buff, "mesh" ) == 0 )
                        state = MESH;
                    else{
                        printf( "A Unknown value \"%s\"\n", buff );
                        break;
                    }
                    break;
                case MESH:{
                        float a,b,c;
                        if( strcmp( buff, "end" ) == 0  ){
                            state = NUL;
                        } else if( sscanf( buff, "vertex %f %f %f", &a, &b, &c ) == 3 ){
                            verts.push_back( { a, b, c } );
                        } else if( sscanf( buff, "normal %f %f %f", &a, &b, &c ) == 3 ){
                            norms.push_back( { a, b, c } );
                            //printf("joos");
                        } else if( sscanf( buff, "texcoord %f %f", &a, &b) == 2 ){
                            tex.push_back( { a, b } );
                        } else if( strcmp( buff, "face" ) == 0  ){
                            state = MESHFACE;
                            face a;
                            faces.push_back( a );
                        }
                        else{
                            printf( "Unknown value \"%s\"\n", buff );
                            break;
                        }
                    }break;
                case MESHFACE:{
                    int off;
                    int t;
                    face* a = &(faces[faces.size()-1]);

                    //printf(" %i ",  ( sscanf( buff, "vertices%n", &off ) | off ) > 8 );
                    if( sscanf( buff, "vertices%n", &off ) | off >= 8 ){
                        buff += off;
                        while( sscanf( buff, " %i%n", &t, &off ) >= 1 ){
                            buff += off;
                            a->vertices.push_back( t );
                            //printf(" HAHA" );
                        }
                    }
                    else if( sscanf( buff, "normals%n", &off ) | off >= 7 ){
                        buff += off;
                        while( sscanf( buff, " %i%n", &t, &off ) >= 1 ){
                            buff += off;
                            a->normals.push_back( t );
                            //printf(" LOLO" );
                        }
                    }
                    else if( sscanf( buff, "texcoords%n", &off ) | off >= 9 ){
                        buff += off;
                        while( sscanf( buff, " %i%n", &t, &off ) >= 1 ){
                            buff += off;
                            a->texcoords.push_back( t );
                            //printf(" YULU %i ", a->texcoords.size() );
                        }
                    }
                    else if(strcmp( buff, "endface" ) == 0  ){
                        state = MESH;

                        break;
                    }


                } break;
                case MATERIAL:{
                        float a,b,c;
                        if( strcmp( buff, "end" ) == 0 ){
                            state = NUL;
                        } else if( sscanf( buff, "vertex %f %f %f", &a, &b, &c ) == 3 ){
                            verts.push_back( { a, b, c } );
                        } else if( sscanf( buff, "normal %f %f %f", &a, &b, &c ) == 3 ){
                            norms.push_back( { a, b, c } );
                        } else if( sscanf( buff, "texcoord %f %f", &a, &b) == 2 ){
                            tex.push_back( { a, b } );
                        }
                        else{
                            printf( "Unknown value \"%s\"\n", buff );
                            break;
                        }
                    }break;

            }
        fgets( buf, 999, f );
    }

}
void mesh::render(){
    for( int i = 0; i < faces.size(); ++i ){
        //puts("a");
        glBegin( GL_POLYGON );
        for( int j = 0; j < faces[i].vertices.size(); ++j ){
            glNormal3f( (norms[faces[i].normals[j]]).x, (norms[faces[i].normals[j]]).y, (norms[faces[i].normals[j]]).z );
            if(  faces[i].texcoords.size() > j )
            glTexCoord2f( tex[ faces[i].texcoords[j] ].u, 1.0-tex[ faces[i].texcoords[j] ].v );
            glVertex3f( verts[faces[i].vertices[j]].x,verts[faces[i].vertices[j]].y,verts[faces[i].vertices[j]].z );
        }
        glEnd();
    }
}

