#include "soundloader.h"


int get_type( const char* fname ){
    FILE* f = fopen( fname, "r" );
    char b[5];
    fread( b, 1, 5, f );
    fclose(f);
    uint8_t tmp[3]={0xFF, 0xFB, 0x90};
    if( memcmp( b, "RIFF", 4 ) == 0 ) return TYPE_WAV;
    if( memcmp( b, "ID3", 3 ) == 0 ) return TYPE_MP3;
    if( memcmp( b, tmp, 3 ) == 0 ) return TYPE_MP3;

    return TYPE_NULL;

}
decoder* load_sound( const char* fname ){
    decoder::info a;
    a.desired_bps = 16;
    a.desired_samplerate = 44100;
    a.desired_sblen = 2048;
    a.desired_channels = 2;
    a.input_filename = fname;
    a.input_type = a.TYPE_FILE;
    decoder* ret = 0;
    switch( get_type(fname) ){
        case TYPE_WAV: ret = new decoderwav( a ); break;
        case TYPE_MP3: ret = new decodermp3( a ); break;
        default: return 0; break;
    }
    ret->decode();
    return ret;
}
